<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\RecurringDonation;
use App\Models\Payment;
use App\Models\Project;
use Carbon\Carbon;

class ProcessRecurringDonations extends Command
{
    protected $signature = 'donations:process-recurring';
    protected $description = 'Process recurring donations';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $recurringDonations = RecurringDonation::all();
        $now = Carbon::now();

        foreach ($recurringDonations as $donation) {
            $shouldDonate = false;

            // تحقق من توقيت التبرع
            if ($donation->frequency == 'daily' && $donation->last_donated_at->diffInDays($now) >= 1) {
                $shouldDonate = true;
            } elseif ($donation->frequency == 'weekly' && $donation->last_donated_at->diffInWeeks($now) >= 1) {
                $shouldDonate = true;
            } elseif ($donation->frequency == 'monthly' && $donation->last_donated_at->diffInMonths($now) >= 1) {
                $shouldDonate = true;
            } elseif ($donation->frequency == 'minutely' && $donation->last_donated_at->diffInMinutes($now) >= 1) {
                $shouldDonate = true;
            }

            if ($shouldDonate) {
                $project = Project::find($donation->project_id);

                if ($project) {
                    // استقطاع المبلغ من المشروع
                    $project->gained += $donation->amount;
                    $project->save();

                    // فك تشفير بيانات gateway_response
                    $gatewayResponse = json_decode($donation->gateway_response, true);
                    $token = $gatewayResponse['response']['source']['token'] ?? null;

                    if (!$token) {
                        $this->error('No token found for donation ID: ' . $donation->id);
                        continue; // تخطي هذه التبرع إذا لم يكن هناك توكن
                    }

                    $paymentData = [
                        'amount' => $donation->amount * 100,
                        'currency' => 'SAR',
                        'source' => [
                            'type' => 'token',
                            'token' => $token,
                            '3ds' => true,
                            'manual' => false,
                        ],
                    ];

                    // متغير لتتبع حالة الدفع
                    $paymentSuccess = false;
                    $retryCount = 0;
                    $maxRetries = 3;

                    while (!$paymentSuccess && $retryCount < $maxRetries) {
                        // إرسال الطلب إلى واجهة برمجة التطبيقات لمؤسسة Moyasar
                        $ch = curl_init('https://api.moyasar.com/v1/payments');
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                        curl_setopt($ch, CURLOPT_USERPWD, 'pk_test_MrtwozLJAuFmLKWWSaRaoaLX:');
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($paymentData));

                        // تنفيذ الطلب
                        $response = curl_exec($ch);
                        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                        curl_close($ch);

                        // تحقق من نجاح العملية
                        if ($httpCode === 200) {
                            // سجل الدفع في قاعدة البيانات
                            $payment = new Payment();
                            $payment->donation_id = $donation->id;
                            $payment->amount = $donation->amount;
                            $payment->status = 'successful';
                            $payment->transaction_id = json_decode($response)->id ?? null; // تحقق من وجود ID المعاملة
                            $payment->save();
                            $paymentSuccess = true; // دفع ناجح
                        } else {
                            $retryCount++;
                            $this->error('Payment failed for donation ID: ' . $donation->id . ', attempt: ' . $retryCount . ', HTTP Code: ' . $httpCode);
                            // انتظر بعض الوقت قبل إعادة المحاولة
                            usleep(2000000); // انتظر لمدة ثانيتين
                        }
                    }

                    // إذا فشلت جميع المحاولات، أرسل إشعار للمستخدم
                    if (!$paymentSuccess) {
                        // يمكنك إرسال إشعار مثل بريد إلكتروني
                        $this->info('All attempts failed for donation ID: ' . $donation->id . '. User has been notified.');
                    }

                    // تحديث تاريخ آخر تبرع
                    $donation->last_donated_at = $now;
                    $donation->save();
                }
            }
        }

        return 0;
    }
}

