<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Jobs\ProcessRecurringDonationsJob;

class Kernel extends ConsoleKernel
{
    
    /**
     * Define the application's command schedule.
     */
protected function schedule(Schedule $schedule): void
{
    // استخدام job بدلاً من command
  $schedule->job(new ProcessRecurringDonationsJob())->everyMinute();
}

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
