<?php

// App\Http\Controllers\AbandonedCartController.php

namespace App\Http\Controllers;

use App\Models\AbandonedCart;
use Illuminate\Http\Request;

class AbandonedCartController extends Controller
{
public function store(Request $request)
{
    // تحقق من صحة البيانات المدخلة
    $request->validate([
        'user_id' => 'required|exists:users,id',
        'cart_items' => 'required|array',
        'cart_items.*.project_id' => 'required|exists:projects,id',
        'cart_items.*.amount' => 'required|numeric|min:1',
    ]);

    // تحقق مما إذا كان للمستخدم سلة متروكة مسبقًا
    $cart = AbandonedCart::where('user_id', $request->user_id)->first();

    if ($cart) {
        // إذا كانت السلة موجودة، قم بتحديثها
        $cart->update([
            'cart_items' => $request->cart_items,
        ]);
        return response()->json(['message' => 'Cart updated successfully', 'cart' => $cart]);
    }

    // إذا لم تكن السلة موجودة، قم بإنشاء سلة جديدة
    $cart = AbandonedCart::create([
        'user_id' => $request->user_id,
        'cart_items' => $request->cart_items,
    ]);

    return response()->json(['message' => 'Cart created successfully', 'cart' => $cart]);
}



    // استرجاع السلة المتروكة حسب المستخدم
    public function getByUser($userId)
    {
        $cart = AbandonedCart::where('user_id', $userId)
            ->with('user') // تحميل بيانات المستخدم
            ->first();

        if (!$cart) {
            return response()->json(['message' => 'No abandoned cart found'], 404);
        }

        return response()->json([
            'cart' => $cart,
            'user' => [
                'name' => $cart->user->name,
                'email' => $cart->user->email,
            ],
        ]);
    }

    // استرجاع كل السلال المتروكة
    public function index()
    {
        $carts = AbandonedCart::with('user')->get(); // تحميل بيانات المستخدم لكل سلة

        return response()->json([
            'carts' => $carts->map(function ($cart) {
                return [
                    'cart' => $cart,
                    'user' => [
                      
                    ],
                ];
            })
        ]);
    }

    // حذف سلة معينة
    public function destroy($id)
    {
        $cart = AbandonedCart::find($id);

        if (!$cart) {
            return response()->json(['message' => 'Cart not found'], 404);
        }

        $cart->delete();

        return response()->json(['message' => 'Cart deleted successfully']);
    }
}
