<?php

namespace App\Http\Controllers;

use App\Models\AboutUs;
use Illuminate\Http\Request;

class AboutUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $aboutUs = AboutUs::all();
        return response()->json($aboutUs);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
 public function store(Request $request)
{
    $validated = $request->validate([
        'title' => 'required|string',
    ]);

    // حذف جميع السجلات القديمة
    AboutUs::truncate();

    // إنشاء السجل الجديد
    $aboutUs = AboutUs::create($validated);

    return response()->json([
        'message' => 'تم تحديث المحتوى بنجاح',
        'data' => $aboutUs,
    ], 201);
}

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $aboutUs = AboutUs::findOrFail($id);
        return response()->json($aboutUs);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'title' => 'required|string',
        ]);

        $aboutUs = AboutUs::findOrFail($id);
        $aboutUs->update($validated);

        return response()->json([
            'message' => 'تم تحديث العنصر بنجاح',
            'data' => $aboutUs,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $aboutUs = AboutUs::findOrFail($id);
        $aboutUs->delete();

        return response()->json([
            'message' => 'تم حذف العنصر بنجاح',
            'data' => $aboutUs,
        ], 204);
    }
}
