<?php

// app/Http/Controllers/AboutUsController.php

namespace App\Http\Controllers;

use App\Models\AboutUs;
use Illuminate\Http\Request;

class AboutUsController extends Controller
{
    // عرض البيانات الخاصة بـ "من نحن"
    public function index()
    {
        return AboutUs::all();
    }

    // إنشاء محتوى "من نحن"
    public function store(Request $request)
    {
        $request->validate([
            'content' => 'required|string',
        ]);

        $aboutUs = AboutUs::create($request->all());
        return response()->json($aboutUs, 201);
    }

    // عرض محتوى "من نحن" معين
    public function show($id)
    {
        return AboutUs::findOrFail($id);
    }

    // تحديث محتوى "من نحن"
    public function update(Request $request, $id)
    {
        $aboutUs = AboutUs::findOrFail($id);
        $aboutUs->update($request->all());
        return response()->json($aboutUs, 200);
    }

    // حذف محتوى "من نحن"
    public function destroy($id)
    {
        AboutUs::findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
