<?php
namespace App\Http\Controllers;

use App\Models\Campaign;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CampaignController extends Controller
{
    public function index()
    {
        $campaigns = Campaign::whereNotIn('status', ['منتهية', 'مكتملة'])->get();
        return response()->json(['Campaigns' => $campaigns], 200);
    }

 public function store(Request $request)
{
    $validatedData = $request->validate([
        'donation_field' => 'required|string|max:255',
        'campaign_name' => 'required|string|max:255',
        'target_amount' => 'required|numeric',
        'collected_amount' => 'nullable|numeric',
        'status' => 'nullable|string|max:255',
        // 'user_id' removed from validation
    ]);

    // إضافة user_id إلى البيانات
    $validatedData['user_id'] = Auth::id(); 

    // إذا لم يتم تقديم الحالة، تعيينها كـ "غير نشط"
    $validatedData['status'] = $validatedData['status'] ?? 'غير نشط';

    // إنشاء حملة جديدة
    $campaign = Campaign::create($validatedData);

    return response()->json($campaign, 201);
}


    public function show($id)
    {
        $campaign = Campaign::where('id', $id)
                            ->where('status', Campaign::STATUS_ACTIVE)
                            ->first();

        if (!$campaign) {
            return response()->json(['message' => 'Campaign not found or not active'], 404);
        }

        return response()->json(['Campaign' => $campaign], 200);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'donation_field' => 'nullable|string|max:255',
            'campaign_name' => 'nullable|string|max:255',
            'target_amount' => 'nullable|numeric',
            'collected_amount' => 'nullable|numeric',
            'status' => 'nullable|string|max:255',
        ]);

        $campaign = Campaign::find($id);
        if (!$campaign) {
            return response()->json(['message' => 'Campaign not found'], 404);
        }

        $campaign->update($request->all());
        return response()->json($campaign);
    }

    public function destroy($id)
    {
        $campaign = Campaign::find($id);
        if (!$campaign) {
            return response()->json(['message' => 'Campaign not found'], 404);
        }

        $campaign->delete();
        return response()->json(['message' => 'Campaign deleted successfully']);
    }

    public function archive()
    {
        $campaigns = Campaign::whereIn('status', [Campaign::STATUS_SUCCESSFUL, Campaign::STATUS_EXPIRED])->get();
        return response()->json(['Campaigns' => $campaigns], 200);
    }

    public function listCampaigns()
    {
        $campaigns = Campaign::where('status', '!=', 'نشط')->get(['id', 'donation_field', 'campaign_name', 'target_amount', 'collected_amount', 'status']);
        return response()->json(['Campaigns' => $campaigns], 200);
    }

    public function userCampaigns()
    {
        $userId = Auth::id();
        $campaigns = Campaign::where('user_id', $userId)->get();
        return response()->json(['Campaigns' => $campaigns], 200);
    }
}
