<?php



namespace App\Http\Controllers;

use App\Models\Coordinator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class CoordinatorController extends Controller
{
    public function index()
    {
        $coordinators = Coordinator::all();
        return response()->json($coordinators);
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:coordinators',
            'phone' => 'required|string|max:15',
            'password' => 'required|string|min:8',
        ]);

        $coordinator = Coordinator::create([
            'name' => $validatedData['name'],
            'email' => $validatedData['email'],
            'phone' => $validatedData['phone'],
            'password' => Hash::make($validatedData['password']),
        ]);

        return response()->json($coordinator, 201);
    }

    public function show($id)
    {
        $coordinator = Coordinator::findOrFail($id);
        return response()->json($coordinator);
    }

    public function update(Request $request, $id)
    {
        $coordinator = Coordinator::findOrFail($id);

        $validatedData = $request->validate([
            'name' => 'sometimes|required|string|max:255',
            'email' => 'sometimes|required|string|email|max:255|unique:coordinators,email,' . $coordinator->id,
            'phone' => 'sometimes|required|string|max:15',
            'password' => 'sometimes|nullable|string|min:8|confirmed',
        ]);

        if ($request->has('name')) {
            $coordinator->name = $validatedData['name'];
        }
        if ($request->has('email')) {
            $coordinator->email = $validatedData['email'];
        }
        if ($request->has('phone')) {
            $coordinator->phone = $validatedData['phone'];
        }
        if ($request->has('password')) {
            $coordinator->password = Hash::make($validatedData['password']);
        }

        $coordinator->save();

        return response()->json($coordinator);
    }

    public function destroy($id)
    {
        $coordinator = Coordinator::findOrFail($id);
        $coordinator->delete();

        return response()->json(['message' => 'Coordinator deleted successfully']);
    }
}
