<?php

namespace App\Http\Controllers;

use App\Models\Message;
use Illuminate\Http\Request;

class MessageController extends Controller
{
    // إنشاء رسالة جديدة
    public function store(Request $request)
    {
        $validated = $request->validate([
            'رقم_الجوال' => 'required|string',
            'نوع_الرسالة' => 'required|string',
            'الرسالة' => 'required|string',
            'تاريخ_الارسال' => 'required|date',
            'الحالة' => 'required|string',
        ]);

        $message = Message::create($validated);
        return response()->json($message, 201);
    }

    // عرض رسالة واحدة
    public function show($id)
    {
        $message = Message::findOrFail($id);
        return response()->json($message);
    }

    // عرض جميع الرسائل
    public function index()
    {
        $messages = Message::all();
        return response()->json($messages);
    }

    // تحديث رسالة
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'رقم_الجوال' => 'string',
            'نوع_الرسالة' => 'string',
            'الرسالة' => 'string',
            'تاريخ_الارسال' => 'date',
            'الحالة' => 'string',
        ]);

        $message = Message::findOrFail($id);
        $message->update($validated);
        return response()->json($message);
    }

    // حذف رسالة
    public function destroy($id)
    {
        $message = Message::findOrFail($id);
        $message->delete();
        return response()->json(null, 204);
    }
}
