<?php

namespace App\Http\Controllers;

use App\Models\Partner;
use Illuminate\Http\Request;
use App\Http\Resources\PartnerResource;

class PartnerController extends Controller
{
    public function index()
    {
        $partners = Partner::all();

        return response()->json([
            'partners' => PartnerResource::collection($partners)
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'العنوان' => 'required|string|max:255',
            'volunteer_id' => 'required|exists:volunteers,id',
        ]);

        $partner = Partner::create($request->all());

        return response()->json([
            'message' => 'Partner created successfully',
            'partner' => new PartnerResource($partner)
        ], 201);
    }


}
