<?php

namespace App\Http\Controllers;

use App\Models\SortProject;
use Illuminate\Http\Request;

class ProjectSortController extends Controller
{
    // عرض جميع الأرقام
   public function showProjectIds()
{
    // جلب الأرقام المرتبة بناءً على الترتيب (الترتيب يتم حسب ترتيب الإضافة في الجدول)
    $sortedProjects = SortProject::orderBy('id')->pluck('project_id');

    // إرجاع الأرقام فقط في الاستجابة
    return response()->json([
        'project_ids' => $sortedProjects
    ]);
}


public function addProjectIds(Request $request)
{
    // استلام المصفوفة من project_ids
    $projectIds = $request->input('project_ids');

    // التحقق إذا كانت المصفوفة موجودة
    if (!$projectIds || !is_array($projectIds)) {
        return response()->json(['message' => 'Invalid project_ids array'], 400);
    }

    // مسح البيانات السابقة في جدول sort_projects
    SortProject::truncate();

    // إضافة الأرقام الجديدة في جدول sort_projects
    foreach ($projectIds as $projectId) {
        SortProject::create(['project_id' => $projectId]);
    }

    // جلب المشاريع المرتبة بناءً على الترتيب الجديد
    $sortedProjectIds = SortProject::orderBy('id')->pluck('project_id');

    return response()->json([
        'message' => 'Project IDs added successfully',
        'project_ids' => $sortedProjectIds
    ]);
}


    // حذف رقم المشروع
    public function deleteProjectId($id)
    {
        $projectId = SortProject::find($id);

        if ($projectId) {
            $projectId->delete();
            return response()->json(['message' => 'Project ID deleted successfully']);
        } else {
            return response()->json(['message' => 'Project ID not found'], 404);
        }
    }
}
