<?php

namespace App\Http\Controllers;

use App\Models\SeoSetting;
use Illuminate\Http\Request;

class SeoSettingController extends Controller
{
    /**
     * Display the SEO settings.
     */
    public function index()
    {
        $settings = SeoSetting::first(); // Assuming there is only one record
        return response()->json($settings);
    }

    /**
     * Show a specific SEO setting.
     */
    public function show($id)
    {
        $settings = SeoSetting::find($id);

        if (!$settings) {
            return response()->json(['message' => 'SEO settings not found'], 404);
        }

        return response()->json($settings);
    }

    /**
     * Store a new SEO setting.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'seoKeywords' => 'nullable|string',
            'seoDescription' => 'nullable|string',
        ]);

        $existingSettings = SeoSetting::first();
        
        if ($existingSettings) {
            return response()->json(['message' => 'SEO settings already exist'], 400);
        }

        $settings = SeoSetting::create($validated);

        return response()->json($settings, 201);
    }

    /**
     * Update the SEO settings.
     */
    public function update(Request $request)
    {
        $validated = $request->validate([
            'seoKeywords' => 'nullable|string',
            'seoDescription' => 'nullable|string',
        ]);

        $settings = SeoSetting::first(); // Assuming there is only one record

        if (!$settings) {
            $settings = SeoSetting::create($validated);
        } else {
            $settings->update($validated);
        }

        return response()->json($settings);
    }

    /**
     * Delete the SEO settings.
     */
    public function destroy()
    {
        $settings = SeoSetting::first();

        if (!$settings) {
            return response()->json(['message' => 'No SEO settings found to delete'], 404);
        }

        $settings->delete();

        return response()->json(['message' => 'SEO settings deleted successfully']);
    }
}
