<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Storage;
use App\Models\SupportRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class SupportRequestController extends Controller
{
    // إنشاء طلب دعم جديد
    public function store(Request $request)
    {
   $validated = $request->validate([
    'title' => 'required|string',
    'message' => 'required|string',
    'img' => 'nullable|image',
    'site_url' => 'required|url',
    'answers' => 'nullable|string',
    'status' => 'nullable|string',
    'api_key' => 'nullable|string'
]);

        if ($request->hasFile('img')) {
            $path = $request->file('img')->store('images', 'public');
            $validated['img'] = 'storage/' . $path;
        }

        $supportRequest = SupportRequest::create($validated);

        return response()->json([
            'message' => 'Support request created successfully',
            'data' => $supportRequest,
        ], 201);
    }

    // استعراض جميع طلبات الدعم
public function index()
{
    $requests = SupportRequest::all()->map(function ($request) {
        if ($request->img) {
            $request->img = ('/' . $request->img);
        }
        return $request;
    });

    return response()->json($requests, 200);
}


    // استعراض طلب دعم محدد
    public function show($id)
    {
        $supportRequest = SupportRequest::findOrFail($id);
        return response()->json($supportRequest, 200);
    }

    // تحديث طلب دعم
     public function update(Request $request, $id)
    {
        try {
          $validated = $request->validate([
    'title' => 'string|nullable',
    'message' => 'string|nullable',
    'img' => 'image|nullable',
    'site_url' => 'url|nullable',
    'answers' => 'string|nullable',
    'status' => 'string|nullable',
    'api_key' => 'string|nullable'
]);

    
    
            $supportRequest = SupportRequest::findOrFail($id);
    
    
            if ($request->hasFile('img')) {
                $path = $request->file('img')->store('images', 'public');
                $validated['img'] = 'storage/' . $path;
            }
    
            $supportRequest->update($validated);
    
            return response()->json([
                'message' => 'Support request updated successfully',
                'data' => $supportRequest,
            ], 200);
        } catch (\Exception $e) {
            Log::error('Error updating support request: ' . $e->getMessage());
    
            return response()->json([
                'message' => 'Failed to update support request',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
    // حذف طلب دعم
    public function destroy($id)
    {
        $supportRequest = SupportRequest::findOrFail($id);
        $supportRequest->delete();

        return response()->json([
            'message' => 'Support request deleted successfully',
        ], 200);
    }
}
