<?php

namespace App\Http\Controllers;

use App\Models\Waqfya; // تضمين الموديل Waqfya
use Illuminate\Http\Request;

class WaqfyaController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'from' => 'required|string|max:255',
            'to' => 'required|string|max:255',
            'donationAmount' => 'required|numeric|min:1',
            'phone' => 'required|string|max:20',
            'user_id' => 'required|exists:users,id',
        ]);

        $waqfya = Waqfya::create($validated);

        return response()->json(['message' => 'Waqfya created successfully', 'data' => $waqfya], 201);
    }

    public function index()
    {
        $waqfyas = Waqfya::all();
        return response()->json(['data' => $waqfyas], 200);
    }

    public function show($id)
    {
        $waqfya = Waqfya::findOrFail($id);
        return response()->json(['data' => $waqfya], 200);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'from' => 'sometimes|required|string|max:255',
            'to' => 'sometimes|required|string|max:255',
            'donationAmount' => 'sometimes|required|numeric|min:1',
            'phone' => 'sometimes|required|string|max:20',
            'user_id' => 'sometimes|required|exists:users,id',
        ]);

        $waqfya = Waqfya::findOrFail($id);
        $waqfya->update($validated);

        return response()->json(['message' => 'Waqfya updated successfully', 'data' => $waqfya], 200);
    }

    public function destroy($id)
    {
        $waqfya = Waqfya::findOrFail($id);
        $waqfya->delete();

        return response()->json(['message' => 'Waqfya deleted successfully'], 200);
    }
}
