<?php

namespace App\Http\Controllers;

use App\Models\WaqfyaData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class WaqfyaDataController extends Controller
{
    // عرض جميع البيانات
    public function index()
    {
        $data = WaqfyaData::all();
        return response()->json([
            'message' => 'تم استرجاع البيانات بنجاح',
            'data' => $data,
        ]);
    }

    // عرض بيانات محددة
    public function show($id)
    {
        $waqfyaData = WaqfyaData::find($id);

        if (!$waqfyaData) {
            return response()->json([
                'message' => 'البيانات غير موجودة',
            ], 404);
        }

        return response()->json([
            'message' => 'تم استرجاع البيانات بنجاح',
            'data' => $waqfyaData,
        ]);
    }

    // إنشاء بيانات جديدة (موجودة بالفعل في سؤالك)
    public function store(Request $request)
    {
        $request->validate([
            'img' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'amounts' => 'required|numeric|min:0',
        ]);

        $path = $request->file('img')->store('waqfya-images', 'public');

        $waqfyaData = WaqfyaData::create([
            'img' => $path,
            'amounts' => $request->amounts,
        ]);

        return response()->json([
            'message' => 'تمت إضافة البيانات بنجاح',
            'data' => [
                'id' => $waqfyaData->id,
                'img_url' => url('public/storage/' . $waqfyaData->img),
                'amounts' => $waqfyaData->amounts,
            ],
        ]);
    }

    // تحديث بيانات
public function update(Request $request, $id)
{
    $waqfyaData = WaqfyaData::find($id);

    if (!$waqfyaData) {
        return response()->json([
            'message' => 'البيانات غير موجودة',
        ], 404);
    }

    // التحقق من البيانات المدخلة
    $request->validate([
        'img' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        'amounts' => 'required|numeric|min:0',
    ]);

    // إذا كانت هناك صورة جديدة
    if ($request->hasFile('img')) {
        // حذف الصورة القديمة إذا كانت موجودة
        if ($waqfyaData->img) {
            Storage::disk('public')->delete($waqfyaData->img);
        }

        // رفع الصورة الجديدة
        $path = $request->file('img')->store('waqfya-images', 'public');
        $waqfyaData->img = $path;
    }

    // تحديث الحقول الأخرى
    $waqfyaData->amounts = $request->amounts;
    $waqfyaData->save();

    return response()->json([
        'message' => 'تم تحديث البيانات بنجاح',
        'data' => [
            'id' => $waqfyaData->id,
            'img_url' => url('public/storage/' . $waqfyaData->img),
            'amounts' => $waqfyaData->amounts,
        ],
    ]);
}


    // حذف بيانات
    public function destroy($id)
    {
        $waqfyaData = WaqfyaData::find($id);

        if (!$waqfyaData) {
            return response()->json([
                'message' => 'البيانات غير موجودة',
            ], 404);
        }

        // حذف الصورة من التخزين
        if ($waqfyaData->img) {
            Storage::disk('public')->delete($waqfyaData->img);
        }

        $waqfyaData->delete();

        return response()->json([
            'message' => 'تم حذف البيانات بنجاح',
        ]);
    }
}
