<?php


namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\MessageGatewayService;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(MessageGatewayService::class, function ($app) {
            return new MessageGatewayService();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
