<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class MessageGatewayService
{
    protected $apiUrl = 'https://app.mobile.net.sa/api/v1/send';
    protected $token = 'sapzWA5c8klA1nTG3QubL1sfZnBfAy9OM8R0l83C'; // أدخل توكن API الخاص بك هنا
    protected $defaultSenderName = 'Mobile.SA'; // اسم المرسل الثابت

    public function sendThankYouMessage($phone, $nameOnCard, $projectName)
    {
        // نص الرسالة المخصص
        $messageBody = "شكراً يا $nameOnCard لتبرعك لمشروع $projectName! علي منصة $this->defaultSenderName";

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->token,
            'Accept' => 'application/json',
        ])->post($this->apiUrl, [
            'number' => $phone,
            'senderName' => $this->defaultSenderName,
            'sendAtOption' => 'Now',
            'messageBody' => $messageBody,
            'allow_duplicate' => true,
        ]);

        if ($response->successful()) {
            return [
                'success' => true,
                'message' => 'Message sent successfully.',
                'data' => $response->json(),
            ];
        } else {
            return [
                'success' => false,
                'message' => 'Failed to send message.',
                'error' => $response->json(),
            ];
        }
    }
}
