<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('category_id'); // حقل المفتاح الخارجي للفئة
            $table->text('title');
            $table->decimal('totalMoney', 15, 2);
            $table->decimal('gained', 15, 2)->default(0);
            $table->string('imgSrc')->nullable();
            $table->string('Sahm1')->nullable();
            $table->string('Sahm2')->nullable();
            $table->string('Sahm3')->nullable();
            $table->string('Sahm4')->nullable();
            $table->string('Sahm5')->nullable();
            $table->string('Sa1')->nullable();
            $table->string('Sa2')->nullable();
            $table->string('Sa3')->nullable();
            $table->string('Sa4')->nullable();
            $table->string('Sa5')->nullable();
            $table->string('description')->nullable();
            $table->decimal('percentage', 5, 2)->nullable()->default(0);
            $table->boolean('show_percentage')->default(true);
            $table->boolean('show_gained')->default(true);
            $table->boolean('show_totalMoney')->default(true);
            $table->boolean('is_visible')->default(true); 
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->timestamps();

            // تعريف المفتاح الخارجي
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropForeign(['category_id']);
        });

        Schema::dropIfExists('projects');
    }
};
