<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->integer('beneficiaries_count')->nullable();
            $table->integer('target_count')->nullable();
            $table->integer('visits')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropColumn('beneficiaries_count');
            $table->dropColumn('target_count');
            $table->dropColumn('visits');
        });
    }
};
