<?php

// database/migrations/xxxx_xx_xx_xxxxxx_add_coordinator_id_to_tracking_links_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCoordinatorIdToTrackingLinksTable extends Migration
{
    public function up()
    {
        Schema::table('tracking_links', function (Blueprint $table) {
            $table->unsignedBigInteger('coordinator_id')->nullable();

            $table->foreign('coordinator_id')
                  ->references('id')
                  ->on('coordinators')
                  ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('tracking_links', function (Blueprint $table) {
            $table->dropForeign(['coordinator_id']);
            $table->dropColumn('coordinator_id');
        });
    }
}
