<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::table('payments', function (Blueprint $table) {
        $table->unsignedBigInteger('tracking_link_id')->nullable()->after('project_id');
        $table->foreign('tracking_link_id')->references('id')->on('tracking_links')->onDelete('set null');
    });
}

public function down()
{
    Schema::table('payments', function (Blueprint $table) {
        $table->dropForeign(['tracking_link_id']);
        $table->dropColumn('tracking_link_id');
    });
}

};
