<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCampaignsTable extends Migration
{
    /**
     * تشغيل الترحيل.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('campaigns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // إضافة عمود user_id
            $table->string('donation_field');
            $table->string('campaign_name');
            $table->decimal('target_amount', 10, 2);
            $table->decimal('collected_amount', 10, 2)->default(0);
            $table->string('status')->default('نشطة');
            $table->timestamps();
            
            // إضافة المفتاح الأجنبي
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * التراجع عن الترحيل.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('campaigns', function (Blueprint $table) {
            // حذف المفتاح الأجنبي قبل حذف العمود
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('campaigns');
    }
}
