<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCampaignIdToPaymentsTable extends Migration
{
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            // تحقق من عدم وجود عمود campaign_id
            if (!Schema::hasColumn('payments', 'campaign_id')) {
                $table->unsignedBigInteger('campaign_id')->nullable()->after('tracking_link_id');
                
                // إضافة المفتاح الأجنبي
                $table->foreign('campaign_id')
                      ->references('id')
                      ->on('campaigns')
                      ->onDelete('cascade');
            }
        });
    }

    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            // تحقق من وجود المفتاح الأجنبي قبل محاولة حذفه
            if (Schema::hasColumn('payments', 'campaign_id')) {
                $table->dropForeign(['campaign_id']);
                
                // حذف العمود
                $table->dropColumn('campaign_id');
            }
        });
    }
}
