<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToProjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('projects', function (Blueprint $table) {
            if (!Schema::hasColumn('projects', 'amount')) {
                $table->decimal('amount', 10, 2)->nullable();
            }
            if (!Schema::hasColumn('projects', 'deduction_period')) {
                $table->string('deduction_period')->nullable();
            }
            if (!Schema::hasColumn('projects', 'deduction_end_date')) {
                $table->date('deduction_end_date')->nullable();
            }
            if (!Schema::hasColumn('projects', 'participantName')) {
                $table->string('participantName')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('projects', function (Blueprint $table) {
            if (Schema::hasColumn('projects', 'amount')) {
                $table->dropColumn('amount');
            }
            if (Schema::hasColumn('projects', 'deduction_period')) {
                $table->dropColumn('deduction_period');
            }
            if (Schema::hasColumn('projects', 'deduction_end_date')) {
                $table->dropColumn('deduction_end_date');
            }
            if (Schema::hasColumn('projects', 'participantName')) {
                $table->dropColumn('participantName');
            }
        });
    }
}

