<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWaqfCertificatesTable extends Migration
{
    public function up()
    {
        Schema::create('waqf_certificates', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم الصك
            $table->decimal('amount', 15, 2); // المبلغ
            $table->string('issued_by'); // عن مين يتم الصك
            $table->string('banner_image'); // صورة البانر
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('waqf_certificates');
    }
}
