<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateProjectsTable extends Migration
{
    public function up()
    {
        Schema::table('projects', function (Blueprint $table) {
            // إضافة الحقول الجديدة
            $table->string('cart_donation_type')->nullable()->after('showSahm');
            $table->string('quick_donation_type')->nullable()->after('cart_donation_type');
            $table->date('cart_deduction_date')->nullable()->after('quick_donation_type');
            $table->date('quick_deduction_date')->nullable()->after('cart_deduction_date');
        });
    }

    public function down()
    {
        Schema::table('projects', function (Blueprint $table) {
            // حذف الحقول الجديدة إذا لزم الأمر
            $table->dropColumn(['cart_donation_type', 'quick_donation_type', 'cart_deduction_date', 'quick_deduction_date']);
        });
    }
}
