<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRecurringDetailsToRecurringDonationsTable extends Migration
{
    public function up()
    {
        Schema::table('recurring_donations', function (Blueprint $table) {
            $table->timestamp('next_donation_at')->nullable(); // وقت التبرع القادم
            $table->string('frequency_interval')->nullable(); // نوع التكرار (مثل "دقيقة"، "ساعة"، "يوم")
        });
    }

    public function down()
    {
        Schema::table('recurring_donations', function (Blueprint $table) {
            $table->dropColumn('next_donation_at');
            $table->dropColumn('frequency_interval');
        });
    }
}
