<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSpecifiedAmountToProjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('projects', function (Blueprint $table) {
            // إضافة حقل specified_amount
            $table->decimal('specified_amount', 10, 2)->nullable()->after('gained'); // يمكنك تحديد مكان الحقل بعد gained
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('projects', function (Blueprint $table) {
            // حذف الحقل عند التراجع
            $table->dropColumn('specified_amount');
        });
    }
}
