<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('request_balances', function (Blueprint $table) {
            $table->id();
            $table->decimal('balance', 15, 2);
            $table->decimal('amount', 15, 2);
            $table->string('transfer_image');
            $table->string('site_url');
            $table->string('status')->nullable();
            $table->string('api_key')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('request_balances');
    }
};
