<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
class Campaign extends Model
{
    use HasFactory;

    protected $fillable = [
        'donation_field',
        'campaign_name',
        'target_amount',
        'collected_amount',
        'status',  
        'user_id',
    ];
    protected $attributes = [
        'status' => 'غير نشط',
    ];
public function user()
{
    return $this->belongsTo(User::class);
}

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    const STATUS_ACTIVE = 'نشط';
    const STATUS_EXPIRED = 'منتهية';
    const STATUS_SUCCESSFUL = 'مكتملة';
    const STATUS_FAILED = 'فشلت';

    public static function getStatusList()
    {
        return [
            self::STATUS_ACTIVE,
            self::STATUS_EXPIRED,
            self::STATUS_SUCCESSFUL,
            self::STATUS_FAILED,
        ];
    }

    public function checkStatus()
    {
        if ($this->collected_amount >= $this->target_amount) {
            $this->status = self::STATUS_SUCCESSFUL;
            $this->save();
        }
    }
}
