<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Color extends Model
{
    use HasFactory;

    // الجدول المرتبط بالنموذج
    protected $table = 'colors';

    // الحقول القابلة للتعبئة
    protected $fillable = [
        'siteColor',
        'adminColor',
        'bodyColor',
        'buttonColor',
    ];

    // الحقول التي يجب تحويلها إلى أنواع أصلية
    protected $casts = [
        'siteColor' => 'string',
        'adminColor' => 'string',
        'bodyColor' => 'string',
        'buttonColor' => 'string',
    ];
}
