<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GiftCard extends Model
{
    use HasFactory;

    protected $fillable = [
        'recipientName',
        'recipientNumber',
        'senderName',
        'senderNumber',
        'amount',
        'sendCardToSenderOption',
    ];

    public function section()
    {
        return $this->belongsTo(Section::class);
    }

    public function image()
    {
        return $this->belongsTo(Image::class);
    }

    public function giftCards()
    {
        return $this->hasMany(GiftCard::class);
    }
}
