<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    // تحديد اسم الجدول إذا كان مختلفًا عن الافتراضي
    protected $table = 'pages';

    // تحديد الحقول القابلة للتعبئة (fillable) عند إجراء عمليات إدخال أو تعديل البيانات
    protected $fillable = ['title', 'page', 'content', 'project_id', 'media', 'is_visible'];


    // إذا كان لديك حقول JSON أو تعليقات توضيحية على الحقول يمكنك تحديد ذلك هنا
    protected $casts = [
        'content' => 'json', // سيحول المحتوى إلى JSON بشكل تلقائي
    ];
}
