<?php

namespace App\Http\Controllers;

use App\Models\BankAccount;
use Illuminate\Http\Request;

class BankAccountController extends Controller
{
    public function index()
    {
        $bankAccounts = BankAccount::all();
        return response()->json($bankAccounts);
    }

    public function store(Request $request)
    {
        $request->validate([
            'bank' => 'required|string|max:255',
            'account' => 'required|string|max:255',
            'iban' => 'required|string|max:34',
        ]);

        $bankAccount = BankAccount::create([
            'bank' => $request->bank,
            'account' => $request->account,
            'iban' => $request->iban,
        ]);

        return response()->json($bankAccount, 201);
    }

    public function show($id)
    {
        $bankAccount = BankAccount::findOrFail($id);
        return response()->json($bankAccount);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'bank' => 'required|string|max:255',
            'account' => 'required|string|max:255',
            'iban' => 'required|string|max:34',
        ]);

        $bankAccount = BankAccount::findOrFail($id);
        $bankAccount->update($request->all());

        return response()->json($bankAccount);
    }

    public function destroy($id)
    {
        $bankAccount = BankAccount::findOrFail($id);
        $bankAccount->delete();

        return response()->json(null, 204);
    }
}
