<?php

namespace App\Http\Controllers;

use App\Models\ContactInfo;
use Illuminate\Http\Request;

class ContactInfoController extends Controller
{
    public function index()
    {
        $contactInfos = ContactInfo::all();
        return response()->json($contactInfos);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:15',
            'email' => 'required|string|email|max:255',
        ]);

        $contactInfo = ContactInfo::create($request->all());

        return response()->json($contactInfo, 201);
    }

    public function show($id)
    {
        $contactInfo = ContactInfo::findOrFail($id);
        return response()->json($contactInfo);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:15',
            'email' => 'required|string|email|max:255',
        ]);

        $contactInfo = ContactInfo::findOrFail($id);
        $contactInfo->update($request->all());

        return response()->json($contactInfo);
    }

    public function destroy($id)
    {
        $contactInfo = ContactInfo::findOrFail($id);
        $contactInfo->delete();

        return response()->json(null, 204);
    }
}
