<?php

// app/Http/Controllers/FAQController.php

namespace App\Http\Controllers;

use App\Models\FAQ;
use Illuminate\Http\Request;

class FAQController extends Controller
{
    // عرض جميع الأسئلة والأجوبة
    public function index()
    {
        return FAQ::all();
    }

    // إنشاء سؤال جديد
    public function store(Request $request)
    {
        $request->validate([
            'question' => 'required|string|max:255',
            'answer' => 'required|string',
        ]);

        $faq = FAQ::create($request->all());
        return response()->json($faq, 201);
    }

    // عرض سؤال معين
    public function show($id)
    {
        return FAQ::findOrFail($id);
    }

    // تحديث سؤال معين
    public function update(Request $request, $id)
    {
        $faq = FAQ::findOrFail($id);
        $faq->update($request->all());
        return response()->json($faq, 200);
    }

    // حذف سؤال معين
    public function destroy($id)
    {
        FAQ::findOrFail($id)->delete();
        return response()->json(null, 204);
    }
}
