<?php

namespace App\Http\Controllers;

use App\Models\Hadiya;
use Illuminate\Http\Request;

class HadiyaController extends Controller
{
    // إنشاء تبرع جديد
    public function store(Request $request)
    {
        $request->validate([
            'gift_type' => 'required|string|max:255',
            'card_design' => 'required|string|max:255',
            'recipient_name' => 'required|string|max:255',
            'recipient_phone' => 'required|string|max:15',
            'sender_name' => 'required|string|max:255',
            'sender_phone' => 'required|string|max:15',
            'send_card_to_sender' => 'required|boolean',
            'amount' => 'required|numeric|min:0',
        ]);

        $hadiya = Hadiya::create($request->all());

        return response()->json(['message' => 'Hadiya created successfully', 'hadiya' => $hadiya], 201);
    }

    // استعراض جميع التبرعات
    public function index()
    {
        $hadiyas = Hadiya::all();
        return response()->json(['hadiyas' => $hadiyas], 200);
    }
}
