<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MessageControl;

class MessageControlController extends Controller
{
    public function index()
    {
        return response()->json(MessageControl::all());
    }

    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|string|in:register,donate', // التحقق من نوع الرسالة
            'name' => 'required|string',
            'message' => 'required|string',
            'active' => 'boolean',
        ]);

        // حذف الرسائل القديمة من نفس النوع
        MessageControl::where('type', $request->type)->delete();

        // إنشاء الإدخال الجديد
        $message = MessageControl::create($request->all());

        return response()->json($message, 201);
    }

public function update(Request $request, $id)
{
    // التحقق من البيانات المدخلة (الحقول المرسلة فقط)
    $request->validate([
        'type' => 'nullable|string|in:register,donate', // التحقق من النوع إذا كان موجودًا
        'name' => 'nullable|string', // التحقق من الاسم إذا كان موجودًا
        'message' => 'nullable|string', // التحقق من الرسالة إذا كانت موجودة
        'active' => 'nullable|boolean', // السماح بتحديث الحقل active فقط
    ]);

    // العثور على الرسالة باستخدام المعرف (ID)
    $message = MessageControl::findOrFail($id);

    // تحديث الحقول المرسلة فقط
    $message->update($request->only(['type', 'name', 'message', 'active']));

    // إرجاع استجابة JSON
    return response()->json($message);
}


    public function destroy($id)
    {
        MessageControl::findOrFail($id)->delete();
        return response()->json(['message' => 'Deleted successfully']);
    }
}
