<?php



namespace App\Http\Controllers;

use App\Models\Partnerss;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PartnerssController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $partnerss = Partnerss::all();
        return response()->json($partnerss);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'logo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        // رفع الصورة
        if ($request->hasFile('logo')) {
            $filePath = $request->file('logo')->store('partners', 'public');
            $validated['logo'] = Storage::url($filePath);
        }

        $partnerss = Partnerss::create($validated);

        return response()->json([
            'message' => 'تم إضافة الشريك بنجاح.',
            'data' => $partnerss,
        ], 201);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $partnerss = Partnerss::findOrFail($id);
        return response()->json($partnerss);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'logo' => 'required|string|max:255',
        ]);

        $partnerss = Partnerss::findOrFail($id);
        $partnerss->update($validated);

        return response()->json([
            'message' => 'تم تحديث بيانات الشريك بنجاح.',
            'data' => $partnerss,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $partnerss = Partnerss::findOrFail($id);
        $partnerss->delete();

        return response()->json([
            'message' => 'تم حذف الشريك بنجاح.',
        ], 204);
    }
}
