<?php
namespace App\Http\Controllers;

use App\Models\SmsMessage;
use Illuminate\Http\Request;

class SmsMessageController extends Controller
{
    public function index()
    {
        $smsMessages = SmsMessage::all();

        return response()->json([
            'smsMessages' => $smsMessages
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'phone_number' => 'required|string|max:255',
            'message' => 'required|string',
            'volunteer_id' => 'required|exists:volunteers,id',
        ]);

        $smsMessage = SmsMessage::create($request->all());

        return response()->json([
            'message' => 'SMS message created successfully',
            'smsMessage' => $smsMessage
        ], 201);
    }
}
