<?php
namespace App\Http\Controllers;

use App\Models\SysNotification;
use Illuminate\Http\Request;
use App\Http\Resources\SysNotificationResource;

class SysNotificationController extends Controller
{
    public function index()
    {
        $notifications = SysNotification::all();

        return response()->json([
            'notifications' => SysNotificationResource::collection($notifications)
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'alert' => 'required|string|max:255',
        ]);

        $notification = SysNotification::create($request->all());

        return response()->json([
            'message' => 'Notification created successfully',
            'notification' => new SysNotificationResource($notification)
        ], 201);
    }

}
