<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Target extends Model
{
    use HasFactory;

    protected $fillable = [
        'target_name',
        'target_amount',
        'date',
        'status',
        'target_settings',
    ];

    protected $casts = [
        'target_settings' => 'array',
    ];

    // علاقة مع نموذج Gift
    public function gifts()
    {
        return $this->hasMany(Gift::class); // إذا كانت العلاقة واحد إلى عدة
    }

    // علاقة مع نموذج Project
    public function projects()
    {
        return $this->hasMany(Project::class); // إذا كانت العلاقة واحد إلى عدة
    }
}
